/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.crops.PaddyFieldBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import xueluoanping.teastory.registry.BlockRegister;

public class RicePlantBlock
extends CropBlock {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public RicePlantBlock(BlockBehaviour.Properties copy) {
        super(copy);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_52244_, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)f_52244_)];
    }

    protected boolean isValidGround(BlockState state, LevelReader worldIn, BlockPos pos) {
        return state.m_60734_() == BlockRegister.paddyField.get();
    }

    protected boolean canPlantSeedlings(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.isValidGround(state, worldIn, pos) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        if ((Integer)state.m_61143_((Property)f_52244_) <= 0) {
            return this.canPlantSeedlings(worldIn.m_8055_(blockpos), worldIn, blockpos);
        }
        return this.isValidGround(worldIn.m_8055_(blockpos), worldIn, blockpos);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        int i;
        super.m_213897_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= 9 && (i = this.m_52305_(state)) < this.m_7419_()) {
            BlockState paddy = worldIn.m_8055_(pos.m_7495_());
            if (!(paddy.m_60734_() instanceof PaddyFieldBlock)) {
                return;
            }
            if (i <= 2 && !((Boolean)paddy.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                return;
            }
            if (i >= 6 && ((Boolean)paddy.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                return;
            }
            float f = RicePlantBlock.m_52272_((Block)this, (BlockGetter)worldIn, (BlockPos)pos);
            if (ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(50.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                worldIn.m_7731_(pos, this.m_52289_(i + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
                if (!this.isNearbyTidy(i + 1, worldIn, pos)) {
                    this.growTogether(i + 1, worldIn, pos.m_122012_());
                    this.growTogether(i + 1, worldIn, pos.m_122019_());
                    this.growTogether(i + 1, worldIn, pos.m_122029_());
                    this.growTogether(i + 1, worldIn, pos.m_122024_());
                }
            }
        }
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.m_213898_(state, worldIn, pos, random);
        this.m_213897_(state, worldIn, pos, random);
    }

    private boolean isNearbyTidy(int age, ServerLevel worldIn, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState state = worldIn.m_8055_(pos.m_121945_(direction));
            if (state.m_60734_() != this || age - (Integer)state.m_61143_((Property)f_52244_) <= 2) continue;
            return false;
        }
        return true;
    }

    private void growTogether(int ageToGrow, ServerLevel worldIn, BlockPos pos) {
        BlockState state = worldIn.m_8055_(pos);
        if (state.m_60734_() == this && (Integer)state.m_61143_((Property)f_52244_) < ageToGrow - 2) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_52244_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)f_52244_) + 1)));
            this.growTogether(ageToGrow - 1, worldIn, pos.m_122012_());
            this.growTogether(ageToGrow - 1, worldIn, pos.m_122019_());
            this.growTogether(ageToGrow - 1, worldIn, pos.m_122029_());
            this.growTogether(ageToGrow - 1, worldIn, pos.m_122024_());
        }
    }

    protected ItemLike m_6404_() {
        return (ItemLike)BlockRegister.riceSeedlings.get();
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)f_52244_);
        if (age > 0) {
            return new ItemStack((ItemLike)BlockRegister.RICE_GRAINS.get());
        }
        return new ItemStack((ItemLike)BlockRegister.riceSeedlings.get());
    }
}

